# Quick Start Guide

Get up and running with Z.AI Language Models in VS Code in under 5 minutes.

## Step 1: Install the Extension

### From Marketplace (Recommended)
1. Open VS Code
2. Press `Ctrl+Shift+X` (or `Cmd+Shift+X` on Mac) to open Extensions
3. Search for "Z.AI Language Models"
4. Click **Install**

### From VSIX File
1. Download the `.vsix` file
2. Open VS Code
3. Press `Ctrl+Shift+P` (or `Cmd+Shift+P` on Mac)
4. Type "Install from VSIX" and select it
5. Choose the downloaded `.vsix` file

## Step 2: Get Your API Key

1. Visit [z.ai/manage-apikey/apikey-list](https://z.ai/manage-apikey/apikey-list)
2. Sign in or create an account
3. Click "Create API Key"
4. Copy your API key (starts with `sk-`)

**Note**: Consider subscribing to the GLM Coding Plan ($3/month) for enhanced features.

## Step 3: Configure the Extension

1. Open Command Palette (`Ctrl+Shift+P` / `Cmd+Shift+P`)
2. Type "Z.AI: Manage API Key"
3. Paste your API key when prompted
4. Press Enter

That's it! The extension is now configured.

## Step 4: Use Your First Model

1. Open Copilot Chat:
   - Press `Ctrl+Alt+I` (Windows/Linux)
   - Press `Cmd+Alt+I` (Mac)
   - Or click the chat icon in the Activity Bar

2. Click the **model picker** dropdown (top of chat)

3. Select a model:
   - **GLM-4.7** - For complex tasks, large context needs
   - **GLM-4.5 Air** - For fast, efficient responses

4. Start chatting! Try:
   ```
   Create a Python function to calculate Fibonacci numbers
   ```

## What You Can Do

### Code Generation
```
Create a REST API with Express.js for user management
```

### Code Explanation
```
@workspace Explain how the authentication works in this codebase
```

### Debugging
```
Why isn't this function returning the expected result?
[paste your code]
```

### Refactoring
```
Refactor this code to use async/await instead of callbacks
```

### Tool Calling
The models can automatically call tools and functions you define in your workspace.

## Tips for Best Results

1. **Be Specific**: The more detail you provide, the better the response
   - ❌ "Make a website"
   - ✅ "Create a responsive landing page with a hero section, features, and contact form"

2. **Use Context**: Reference files and workspace with `@` mentions
   - `@workspace` - Reference entire workspace
   - `@file:src/app.ts` - Reference specific file

3. **Choose the Right Model**:
   - Use **GLM-4.7** for complex multi-file projects
   - Use **GLM-4.5 Air** for quick questions and iterations

4. **Enable Thinking Mode** (default on):
   - Better for complex problems
   - Disable in settings for faster responses on simple tasks

## Settings

Customize the extension:
1. Open Settings (`Ctrl+,` / `Cmd+,`)
2. Search for "Z.AI"
3. Adjust:
   - **Enable Thinking Mode**: Toggle complex reasoning
   - **API Endpoint**: Change if using a custom endpoint
   - **Timeout**: Adjust request timeout

## Troubleshooting

### Models Not Appearing

**Check your requirements**:
- VS Code version 1.104.0 or higher
- GitHub Copilot individual plan (Free/Pro/Pro+)
- Valid API key configured

**Steps**:
1. Run `Z.AI: Manage API Key` to verify key is set
2. Restart VS Code
3. Open Copilot Chat and check model picker

### API Key Errors

If you see "Invalid API key" or 401 errors:
1. Verify your key at [z.ai/manage-apikey](https://z.ai/manage-apikey/apikey-list)
2. Run `Z.AI: Clear API Key`
3. Run `Z.AI: Manage API Key` with the correct key
4. Restart VS Code

### Slow Responses

- Check your internet connection
- Try GLM-4.5 Air for faster responses
- Disable thinking mode in settings for simple queries
- Increase timeout in settings if needed

### No Response

1. Check Output panel: View > Output > "Language Model Chat Provider"
2. Look for error messages
3. Try a simpler prompt to test connection
4. Verify Z.AI API status

## Examples

### Create a Full-Stack App
```
Create a todo list app with:
- React frontend with TypeScript
- Node.js/Express backend
- SQLite database
- RESTful API
- Clean, modern UI
```

### Analyze Code Quality
```
@workspace Review the code quality and suggest improvements for:
- Performance
- Security
- Best practices
- Code organization
```

### Debug an Issue
```
This function is throwing an error. Help me debug:

[paste error message and code]

Expected behavior: [describe what should happen]
Actual behavior: [describe what's happening]
```

### Generate Tests
```
Write comprehensive unit tests for this module:

[paste code]

Include edge cases and error handling tests.
```

## Next Steps

- Read the full [README](README.md) for detailed features
- Check [DEVELOPMENT.md](DEVELOPMENT.md) if you want to contribute
- Visit [docs.z.ai](https://docs.z.ai) for API documentation
- Join the [Z.AI Discord](https://discord.gg/QR7SARHRxK) for support

## Getting Help

- **Extension Issues**: [GitHub Issues](https://github.com/yourusername/zai-vscode-extension/issues)
- **API Questions**: [Z.AI Documentation](https://docs.z.ai)
- **Community Support**: [Discord](https://discord.gg/QR7SARHRxK)

---

**Happy coding with Z.AI! 🚀**
