# Z.AI Language Models for VS Code

Bring Z.AI's powerful GLM models to Visual Studio Code's Copilot Chat! This extension provides native integration with GLM-4.7 and GLM-4.5-Air, offering advanced coding, reasoning, and tool-calling capabilities directly in your editor.

## Features

- **GLM-4.7**: Z.AI's flagship model with 200K context window, advanced reasoning, and thinking modes
- **GLM-4.5-Air**: Lightweight, efficient model optimized for speed with 128K context
- **Native Tool Calling**: Full support for function calling and tool use
- **Thinking Mode**: Enable complex reasoning for challenging tasks
- **Streaming Responses**: Real-time response streaming for immediate feedback
- **Secure API Key Storage**: Your credentials are stored securely using VS Code's secret storage

## Requirements

- Visual Studio Code version 1.104.0 or higher
- A Z.AI API key (get one at [z.ai](https://z.ai/manage-apikey/apikey-list))
- GitHub Copilot individual plan (Free, Pro, or Pro+)

## Installation

1. Install the extension from the VS Code Marketplace
2. Open the Command Palette (Ctrl/Cmd+Shift+P)
3. Run `Z.AI: Manage API Key`
4. Enter your Z.AI API key when prompted

## Usage

### Basic Chat

1. Open Copilot Chat (Ctrl/Cmd+Alt+I)
2. Click the model picker dropdown
3. Select either `GLM-4.7` or `GLM-4.5 Air`
4. Start chatting!

### Model Selection

**GLM-4.7** - Best for:
- Complex coding tasks requiring deep reasoning
- Multi-file software engineering
- Tasks requiring 200K context window
- Advanced tool calling and web browsing
- High-quality UI/frontend generation

**GLM-4.5-Air** - Best for:
- Fast, efficient responses
- Cost-effective usage
- Standard coding tasks
- Quick iterations and prototyping

### Thinking Mode

By default, thinking mode is enabled for both models. This allows the models to "think before acting," improving quality on complex tasks. You can disable it in settings:

1. Go to Settings (Ctrl/Cmd+,)
2. Search for "Z.AI"
3. Toggle "Enable Thinking Mode"

## Configuration

Access settings through File > Preferences > Settings, then search for "Z.AI":

| Setting | Description | Default |
|---------|-------------|---------|
| `zai.apiEndpoint` | Z.AI API endpoint URL | `https://api.z.ai/api/coding/paas/v4` |
| `zai.enableThinkingMode` | Enable thinking mode for complex reasoning | `true` |
| `zai.timeout` | Request timeout in milliseconds | `60000` |

## Commands

| Command | Description |
|---------|-------------|
| `Z.AI: Manage API Key` | Set or update your Z.AI API key |
| `Z.AI: Clear API Key` | Remove your stored API key |

## Model Specifications

### GLM-4.7
- **Context Window**: 200,000 tokens input, 128,000 tokens output
- **Capabilities**: Tool calling, thinking modes (Interleaved, Preserved, Turn-level)
- **Strengths**: 
  - 73.8% on SWE-bench Verified
  - 41% on Terminal Bench 2.0
  - 42.8% on HLE (Humanity's Last Exam)
  - Enhanced UI/frontend generation ("Vibe Coding")

### GLM-4.5-Air
- **Context Window**: 128,000 tokens input, 96,000 tokens output
- **Capabilities**: Tool calling, hybrid reasoning (thinking/non-thinking modes)
- **Strengths**:
  - 100+ tokens/second generation speed
  - 4-7x more cost-effective than competitors
  - 0.64s time-to-first-token

## Pricing

Z.AI offers competitive pricing:
- **GLM Coding Plan**: Starting at $3/month (3× usage at reduced costs)
- **API Pricing**: ~$0.60 per 1M input tokens, ~$2.20 per 1M output tokens
- **Context Caching**: Available for reduced costs on repeated prompts

Get your API key and view pricing at [z.ai](https://z.ai/subscribe).

## Troubleshooting

### Models not appearing
1. Verify your API key is set: Run `Z.AI: Manage API Key`
2. Check your GitHub Copilot plan supports custom models
3. Ensure VS Code version is 1.104.0 or higher

### API errors
- **401/403 errors**: Check your API key is valid
- **Timeout errors**: Increase timeout in settings or check network connection
- **Rate limits**: Consider upgrading your Z.AI plan

### Tool calling issues
- Ensure `toolCalling` capability is enabled for your selected model
- Check that the tools you're using follow OpenAI function calling format

## Known Limitations

- Image input is not currently supported (both models are text-only)
- Models are only available to individual GitHub Copilot plan users
- Token counting uses estimation (4 chars/token) rather than true tokenization

## Development

Want to contribute or run from source?

```bash
# Clone the repository
git clone https://github.com/yourusername/zai-vscode-extension
cd zai-vscode-extension

# Install dependencies
npm install

# Compile
npm run compile

# Run in development
# Press F5 in VS Code to open Extension Development Host
```

## Feedback & Support

- Report issues: [GitHub Issues](https://github.com/yourusername/zai-vscode-extension/issues)
- Z.AI Documentation: [docs.z.ai](https://docs.z.ai)
- Z.AI Developer Support: [Discord](https://discord.gg/QR7SARHRxK)

## License

MIT License - see LICENSE file for details

## Acknowledgments

- Built using the [VS Code Language Model Chat Provider API](https://code.visualstudio.com/api/extension-guides/ai/language-model-chat-provider)
- Powered by [Z.AI](https://z.ai) and Zhipu AI's GLM models
- Inspired by the growing ecosystem of AI coding assistants

---

**Note**: This extension requires an active Z.AI API subscription. Visit [z.ai](https://z.ai) to get started.
