import * as vscode from 'vscode';

const API_KEY_SECRET = 'zai.apiKey';

export class ApiKeyManager {
    constructor(private context: vscode.ExtensionContext) {}

    async getApiKey(): Promise<string | undefined> {
        return await this.context.secrets.get(API_KEY_SECRET);
    }

    async setApiKey(apiKey: string): Promise<void> {
        await this.context.secrets.store(API_KEY_SECRET, apiKey);
    }

    async clearApiKey(): Promise<void> {
        await this.context.secrets.delete(API_KEY_SECRET);
    }

    async hasApiKey(): Promise<boolean> {
        const key = await this.getApiKey();
        return !!key && key.length > 0;
    }
}
