### @vscode/test-cli

> This is an experimental command-line test runner is available. Its API may change as we get feedback on it. Please try it out!

This is an configuration-driver command line runner for [VS Code extension tests](https://code.visualstudio.com/api/working-with-extensions/testing-extension). It provides a simple, configuration-driven interface for running tests, and has its own VS Code extension that allows running tests in the UI.

Install with:

```
npm install --save-dev @vscode/test-cli
```

After installing the package, the runner is available as the `vscode-test` CLI. Running it will look for a `.vscode-test.(js/json/mjs)` file relative to the current working directory. You can see the configuration [here](https://github.com/microsoft/vscode-test-cli/blob/main/src/config.cts). This may be as simple as:

```js
// .vscode-test.mjs
import { defineConfig } from '@vscode/test-cli';

export default defineConfig({ files: 'out/test/**/*.test.js' });
```

Or include more options. For example:

```js
// .vscode-test.mjs
import { defineConfig } from '@vscode/test-cli';

export default defineConfig([
  {
    // Required: Glob of files to load (can be an array and include absolute paths).
    files: 'out/test/**/*.test.js',
    // Optional: Version to use, same as the API above, defaults to stable
    version: 'insiders',
    // Optional: Root path of your extension, same as the API above, defaults
    // to the directory this config file is in
    extensionDevelopmentPath: __dirname,
    // Optional: sample workspace to open
    workspaceFolder: `${__dirname}/sampleWorkspace`,
    // Optional: install additional extensions to the installation prior to testing. By
    //default, any `extensionDependencies` from the package.json are automatically installed.
    installExtensions: ['ms-vscode.js-debug-nightly'],
    // Optional: additional mocha options to use:
    mocha: {
      require: `./out/test-utils.js`,
      timeout: 20000,
    },
  },
  // you can specify additional test configurations if necessary
]);
```

Tests included with this command line are run in Mocha. You can run the tests simply by running `vscode-test` on the command line. You can view more options with `vscode-test --help`; this command line is very similar to Mocha. For example, to watch and run only tests named "addition", you can run:

```sh
vscode-test --watch 'out/**/*.js' --grep 'addition'
```

#### Debugging

Add or update an `extensionHost` launch-type config with the path to your test configuration:

```diff
{
	"type": "extensionHost",
	"request": "launch",
	"name": "My extension tests",
+	"testConfiguration": "${workspaceFolder}/.vscode-test.js",
	"args": ["--extensionDevelopmentPath=${workspaceFolder}"]
},
```

## Contributing

This project welcomes contributions and suggestions. Most contributions require you to agree to a
Contributor License Agreement (CLA) declaring that you have the right to, and actually do, grant us
the rights to use your contribution. For details, visit https://cla.opensource.microsoft.com.

When you submit a pull request, a CLA bot will automatically determine whether you need to provide
a CLA and decorate the PR appropriately (e.g., status check, comment). Simply follow the instructions
provided by the bot. You will only need to do this once across all repos using our CLA.

This project has adopted the [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/).
For more information see the [Code of Conduct FAQ](https://opensource.microsoft.com/codeofconduct/faq/) or
contact [opencode@microsoft.com](mailto:opencode@microsoft.com) with any additional questions or comments.

## Trademarks

This project may contain trademarks or logos for projects, products, or services. Authorized use of Microsoft
trademarks or logos is subject to and must follow
[Microsoft's Trademark & Brand Guidelines](https://www.microsoft.com/en-us/legal/intellectualproperty/trademarks/usage/general).
Use of Microsoft trademarks or logos in modified versions of this project must not cause confusion or imply Microsoft sponsorship.
Any use of third-party trademarks or logos are subject to those third-party's policies.
