"use strict";
/*---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
const Mocha = __importStar(require("mocha"));
const util_1 = require("util");
const fullJsonStreamReporterTypes_cjs_1 = require("./fullJsonStreamReporterTypes.cjs");
__exportStar(require("./fullJsonStreamReporterTypes.cjs"), exports);
/**
 * Similar to the mocha JSON stream, but includes additional information
 * on failure and when tests run. Specifically, the mocha json-stream does not
 * include unmangled expected versus actual results.
 *
 * Writes a superset of the data that json-stream normally would.
 */
module.exports = class FullJsonStreamReporter {
    constructor(runner) {
        const total = runner.total;
        runner.once(Mocha.Runner.constants.EVENT_RUN_BEGIN, () => writeEvent([fullJsonStreamReporterTypes_cjs_1.MochaEvent.Start, { total }]));
        runner.once(Mocha.Runner.constants.EVENT_RUN_END, () => writeEvent([fullJsonStreamReporterTypes_cjs_1.MochaEvent.End, {}]));
        runner.on(Mocha.Runner.constants.EVENT_SUITE_BEGIN, (suite) => writeEvent([fullJsonStreamReporterTypes_cjs_1.MochaEvent.SuiteStart, { path: suite.titlePath(), file: suite.file }]));
        runner.on(Mocha.Runner.constants.EVENT_TEST_BEGIN, (test) => writeEvent([fullJsonStreamReporterTypes_cjs_1.MochaEvent.TestStart, clean(test)]));
        runner.on(Mocha.Runner.constants.EVENT_TEST_PASS, (test) => writeEvent([fullJsonStreamReporterTypes_cjs_1.MochaEvent.Pass, clean(test)]));
        runner.on(Mocha.Runner.constants.EVENT_TEST_FAIL, (test, err) => {
            writeEvent([
                fullJsonStreamReporterTypes_cjs_1.MochaEvent.Fail,
                {
                    ...clean(test),
                    actual: (0, util_1.inspect)(err.actual, { depth: 30 }),
                    expected: (0, util_1.inspect)(err.expected, { depth: 30 }),
                    err: err.message,
                    stack: err.stack || null,
                },
            ]);
        });
    }
};
function writeEvent(event) {
    process.stdout.write(JSON.stringify(event) + '\n');
}
const clean = (test) => {
    return {
        path: test.titlePath(),
        duration: test.duration,
        currentRetry: test.currentRetry(),
        file: test.file,
        speed: !test.duration || test.duration < test.slow() / 2
            ? 'fast'
            : test.duration > test.slow()
                ? 'slow'
                : 'medium',
    };
};
