export declare enum MochaEvent {
    Start = "start",
    TestStart = "testStart",
    Pass = "pass",
    Fail = "fail",
    End = "end",
    SuiteStart = "suiteStart"
}
export interface IStartEvent {
    total: number;
}
export interface ITestStartEvent {
    path: string[];
    currentRetry: number;
    file?: string;
}
export interface IPassEvent extends ITestStartEvent {
    duration?: number;
    speed: 'fast' | 'medium' | 'slow';
}
export interface IFailEvent extends IPassEvent {
    err: string;
    stack: string | null;
    expected?: string;
    actual?: string;
}
export interface IEndEvent {
}
export interface ISuiteStartEvent {
    path: string[];
    file?: string;
}
export type MochaEventTuple = [MochaEvent.Start, IStartEvent] | [MochaEvent.TestStart, ITestStartEvent] | [MochaEvent.Pass, IPassEvent] | [MochaEvent.Fail, IFailEvent] | [MochaEvent.End, IEndEvent] | [MochaEvent.SuiteStart, ISuiteStartEvent];
