"use strict";
/*---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.run = void 0;
const mocha_1 = __importDefault(require("mocha"));
async function run() {
    const { mochaOpts, files, preload, colorDefault, } = JSON.parse(process.env.VSCODE_TEST_OPTIONS);
    // Create the mocha test
    const mocha = new mocha_1.default({
        ui: 'tdd',
        color: colorDefault,
        ...mochaOpts,
    });
    const required = [
        ...preload,
        ...ensureArray(mochaOpts.require),
    ].map((f) => require(f));
    // currently `require` only seems to take effect for parallel runs, but remove
    // the option in case it's supported for serial runs in the future since we're
    // handling it ourselves.
    delete mochaOpts.require;
    for (const { mochaGlobalSetup } of required) {
        await mochaGlobalSetup?.();
    }
    for (const file of files) {
        mocha.addFile(file);
    }
    await new Promise((resolve, reject) => mocha.run((failures) => failures
        ? reject(failures > 1 ? `${failures} tests failed.` : `${failures} test failed.`)
        : resolve()));
    for (const { mochaGlobalTeardown } of required) {
        await mochaGlobalTeardown?.();
    }
}
exports.run = run;
const ensureArray = (value) => value ? (Array.isArray(value) ? value : [value]) : [];
