"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiKeyManager = void 0;
const API_KEY_SECRET = 'zai.apiKey';
class ApiKeyManager {
    constructor(context) {
        this.context = context;
    }
    async getApiKey() {
        return await this.context.secrets.get(API_KEY_SECRET);
    }
    async setApiKey(apiKey) {
        await this.context.secrets.store(API_KEY_SECRET, apiKey);
    }
    async clearApiKey() {
        await this.context.secrets.delete(API_KEY_SECRET);
    }
    async hasApiKey() {
        const key = await this.getApiKey();
        return !!key && key.length > 0;
    }
}
exports.ApiKeyManager = ApiKeyManager;
//# sourceMappingURL=apiKeyManager.js.map