"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.activate = activate;
exports.deactivate = deactivate;
const vscode = __importStar(require("vscode"));
const provider_1 = require("./provider");
const apiKeyManager_1 = require("./apiKeyManager");
let provider;
async function activate(context) {
    console.log('Z.AI Language Models extension is now active');
    // Initialize API key manager
    const apiKeyManager = new apiKeyManager_1.ApiKeyManager(context);
    // Create and register the provider
    provider = new provider_1.ZAIChatModelProvider(apiKeyManager);
    const providerDisposable = vscode.lm.registerLanguageModelChatProvider('zai', provider);
    context.subscriptions.push(providerDisposable);
    // Register commands
    const manageApiKeyCommand = vscode.commands.registerCommand('zai.manageApiKey', async () => {
        const apiKey = await vscode.window.showInputBox({
            prompt: 'Enter your Z.AI API Key',
            password: true,
            placeHolder: 'sk-...',
            validateInput: (value) => {
                if (!value || value.trim().length === 0) {
                    return 'API key cannot be empty';
                }
                return null;
            }
        });
        if (apiKey) {
            await apiKeyManager.setApiKey(apiKey);
            vscode.window.showInformationMessage('Z.AI API key saved successfully');
            // Refresh the provider to pick up the new key
            if (provider) {
                await provider.refresh();
            }
        }
    });
    const clearApiKeyCommand = vscode.commands.registerCommand('zai.clearApiKey', async () => {
        const confirm = await vscode.window.showWarningMessage('Are you sure you want to clear your Z.AI API key?', 'Yes', 'No');
        if (confirm === 'Yes') {
            await apiKeyManager.clearApiKey();
            vscode.window.showInformationMessage('Z.AI API key cleared');
            // Refresh the provider
            if (provider) {
                await provider.refresh();
            }
        }
    });
    context.subscriptions.push(manageApiKeyCommand, clearApiKeyCommand);
    // Show welcome message on first activation
    const hasSeenWelcome = context.globalState.get('zai.hasSeenWelcome', false);
    if (!hasSeenWelcome) {
        const setupAction = 'Setup API Key';
        const result = await vscode.window.showInformationMessage('Welcome to Z.AI Language Models! Set up your API key to get started.', setupAction, 'Later');
        if (result === setupAction) {
            await vscode.commands.executeCommand('zai.manageApiKey');
        }
        await context.globalState.update('zai.hasSeenWelcome', true);
    }
}
function deactivate() {
    console.log('Z.AI Language Models extension is now deactivated');
}
//# sourceMappingURL=extension.js.map